--
-- @file Macro_Hair.mcr
--
-- @author Gonzalo Rueda <grueda@animatedpixel.com>
--
-- $Started: 2004/08/02 $
-- $Date: 2006/08/10 03:27:27 $
-- $Revision: 1.1 $
--
-- @brief   These are the macro scripts declared by Hair.
--
-- Copyright Joe Alter, Inc. 2004 
--
-- This work may not be duplicated, in whole or part, without the express
-- written permission of Joe Alter, Inc.
--


macroScript Hair_AddMod 
            category:~HAIR_ADDMOD_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~ADD_HAIR_MODIFIER_TOOLTIP~
            buttontext:~ADD_HAIR_MODIFIER_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         hair.addMod $
		   setCommandPanelTaskMode mode:#create
		   setCommandPanelTaskMode mode:#modify
		   completeRedraw()
      )
   )
)


macroScript Hair_AddEffect
            category:~HAIR_ADDEFFECT_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~ADD_HAIR_EFFECT_TOOLTIP~
            buttontext:~ADD_HAIR_EFFECT_BUTTONTEXT~
(
   on execute do
   (
      hair.addEffect true
   )
)


macroScript Hair_Purge
            category:~HAIR_PURGE_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~PURGE_TOOLTIP~
            buttontext:~PURGE_BUTTONTEXT~
(
   on execute do
   (
      hair.Purge()
   )
)


macroScript Hair_AddHairProperties
            category:~ADDHAIRPROPERTIES_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~ADDHAIRPROPERTIES_TOOLTIP~
            buttontext:~ADDHAIRPROPERTIES_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         hair.AddHairProperties $
      )
   )
)


macroScript Hair_ConvertHairsToMesh
            category:~CONVERTHAIRSTOMESH_HAIR_AND_FUR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~CONVERTHAIRSTOMESH_TOOLTIP~
            buttontext:~CONVERTHAIRSTOMESH_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()

			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.ConvertToMesh instance:obj
			break
		 )
      )
   )
)


macroScript Hair_ConvertHairsToSplines
            category:~CONVERTHAIRSTOSPLINES_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~CONVERT_HAIRS_TO_SPLINES_TOOLTIP~
            buttontext:~CONVERTHAIRSTOSPLINES_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ConvertHairsToSplines instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ConvertGuidesToSplines
            category:~CONVERTGUIDESTOSPLINES_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~CONVERT_GUIDES_TO_SPLINES_TOOLTIP~
            buttontext:~CONVERTGUIDESTOSPLINES_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ConvertGuidesToSplines instance:obj
			break
		 )
      )
   )
)

macroScript Hair_CopyHairdo
            category:~HAIR_COPYHAIRDO_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~COPY_HAIRDO_TOOLTIP~
            buttontext:~COPYHAIRDO_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.CopyHairdo instance:obj
			break
		 )
      )
   )
)

macroScript Hair_PasteHairdo
            category:~PASTEHAIRDO_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~PASTEHAIRDO_TOOLTIP~
            buttontext:~PASTEHAIRDO_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.PasteHairdo instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ReplaceRest
            category:~REPLACEREST_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~REPLACEREST_TOOLTIP~
            buttontext:~REPLACEREST_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ResetRest instance:obj
			break
		 )
      )
   )
)

macroScript Hair_RegrowHair
            category:~REGROWHAIR_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~REGROWHAIR_TOOLTIP~
            buttontext:~REGROWHAIR_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.RegrowHair instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ClearHairInstanceMesh
            category:~CLEARHAIRINSTANCEMESH_CATEGORY~ 
            internalCategory:"Hair" 
            tooltip:~CLEARHAIRINSTANCEMESH_TOOLTIP~
            buttontext:~CLEARHAIRINSTANCEMESH_BUTTONTEXT~
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()

			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.ClearInstance()
			break
		 )
      )
   )
)

